-- [ja] 情報読み込み 
local drFile={};
local drInfo={};
drFile=getenv("drFile");
drInfo=getenv("drInfo");
local lvInfo={};
lvInfo=getenv("lvInfo");
local DrillScore=getenv("DrillScore");

local jud=GetUserPref_Theme("UserJudgementLabel");
local difn=GetUserPref_Theme("UserDifficultyName");
local difc=GetUserPref_Theme("UserDifficultyColor");
local wheelmode=GetUserPref_Theme("UserWheelMode");

local BASE_TOP_CENTER_X=SCREEN_CENTER_X+_HS2
local BASE_TOP_CENTER_Y=SCREEN_CENTER_Y-130;
local DJACKET_CENTER_X=BASE_TOP_CENTER_X-170;
local DJACKET_CENTER_Y=BASE_TOP_CENTER_Y;
local DTITLE_CENTER_X=BASE_TOP_CENTER_X+90;
local DTITLE_CENTER_Y=BASE_TOP_CENTER_Y;

local BASE_BOTTOM_CENTER_X=SCREEN_CENTER_X+_HS2
local BASE_BOTTOM_CENTER_Y=SCREEN_CENTER_Y+80;
local SJACKET_CENTER_X=BASE_BOTTOM_CENTER_X-170;
local SJACKET_CENTER_Y=BASE_BOTTOM_CENTER_Y+25;
local INFO_CENTER_X=BASE_BOTTOM_CENTER_X+80;
local INFO_CENTER_Y=BASE_BOTTOM_CENTER_Y;
local BORDER_CENTER_X=INFO_CENTER_X-55;
local BORDER_CENTER_Y=INFO_CENTER_Y-60;
local STITLE_CENTER_X=INFO_CENTER_X;
local STITLE_CENTER_Y=BORDER_CENTER_Y;
local BORDER_W=210;
local BORDER_W2=BORDER_W/2;
local BORDER_W100=BORDER_W/100;

local sys_selsong=0;
local sys_sellevel=getenv("sys_sellevel") or 1;

local cal='Off';
local nm=ToEnumShortString(getenv("DrillPlayer"));
if PROFILEMAN:GetNumLocalProfiles()>0 then
	for i=1,PROFILEMAN:GetNumLocalProfiles() do
		if PROFILEMAN:GetProfile(getenv("DrillPlayer")):GetDisplayName()==PROFILEMAN:GetLocalProfileFromIndex(i-1):GetDisplayName() then
			nm="["..PROFILEMAN:GetLocalProfileIDFromIndex(i-1).."]";
			break
		end;
	end;
end;
local cal_prof;
if PROFILEMAN:IsPersistentProfile(getenv("DrillPlayer")) then
	-- player profile
	cal_prof = PROFILEMAN:GetProfile(getenv("DrillPlayer"));
else
	-- machine profile
	cal_prof = PROFILEMAN:GetMachineProfile();
end;
cal=GetUserPref_Theme("UserShowCalories"..nm);
if not cal then cal='Off' end;
local cal_total=0;
if cal_prof then
	cal_total=cal_prof:GetCaloriesBurnedToday();
end;

local sg;
local df;
local gradepoint=0.0;

local t=Def.ActorFrame{};
local t2=Def.ActorFrame{};
t2[#t2+1]=Def.ActorFrame{
	OnCommand=function(self)
		self:queuecommand("Set");
		self:addy(-SCREEN_HEIGHT);
		self:decelerate(_TT.S_IN);
		self:addy(SCREEN_HEIGHT);
	end;
	OffCommand=function(self)
		self:accelerate(_TT.S_OUT);
		self:addy(SCREEN_HEIGHT);
	end;
	SetRCommand=function(self)
		self:finishtweening();
		self:queuecommand("Set");
	end;
	SetCommand=function(self)
		if not getenv("sys_selsong") then
			sys_selsong=0;
		else
			sys_selsong=getenv("sys_selsong");
		end;
		if getenv("sys_move") then
			if getenv("sys_move")=="left" then
				self:queuecommand("MoveLeft");
			elseif getenv("sys_move")=="right" then
				self:queuecommand("MoveRight");
			end;
			setenv("sys_move",nil);
		end;
	end;
	Def.Actor{
		SetCommand=function(self)
			local chk=(sys_selsong==0) and "" or "-"..sys_selsong;
			sg=nil;
			df=nil;
			gradepoint=0.0;
			if sys_selsong>0 then
				_,sg,df=GetDrillSong(lvInfo[""..sys_sellevel.."-Song"][sys_selsong]);
				if sg then
					local stt=GAMESTATE:GetCurrentStyle():GetStepsType();
					if stt then
						local st=sg:GetOneSteps(stt,df);
						gradepoint=GradeChk(st,DrillScore["Drill_W1"..chk],DrillScore["Drill_W2"..chk],DrillScore["Drill_W3"..chk],DrillScore["Drill_W4"..chk],DrillScore["Drill_W5"..chk],DrillScore["Drill_MS"..chk],DrillScore["Drill_OK"..chk],DrillScore["Drill_HIT"..chk]);
					end;
				end;
			else
				local st_cnt=0;
				local hd_cnt=0;
				for stage=1,getenv("DrillMaxStage") do
					local _,_sg,_df=GetDrillSong(lvInfo[""..sys_sellevel.."-Song"][stage]);
					if _sg then
						local stt=GAMESTATE:GetCurrentStyle():GetStepsType();
						if stt then
							local st=_sg:GetOneSteps(stt,_df);
							st_cnt=st_cnt+st:GetRadarValues(GAMESTATE:GetMasterPlayerNumber()):GetValue('RadarCategory_TapsAndHolds');
							hd_cnt=hd_cnt+st:GetRadarValues(GAMESTATE:GetMasterPlayerNumber()):GetValue('RadarCategory_Holds');
							hd_cnt=hd_cnt+st:GetRadarValues(GAMESTATE:GetMasterPlayerNumber()):GetValue('RadarCategory_Rolls');
						end;
					end;
				end;
				gradepoint=GradeChkSetMax(st_cnt,hd_cnt,DrillScore["Drill_W1"],DrillScore["Drill_W2"],DrillScore["Drill_W3"],DrillScore["Drill_W4"],DrillScore["Drill_W5"],DrillScore["Drill_MS"],DrillScore["Drill_OK"],DrillScore["Drill_HIT"]);
			end;
		end;
	};
--Base(TOP)
	--Def.Quad{
	LoadActor(THEME:GetPathG("_SelectMusic/white","banner"))..{
		OnCommand=function(self)
			self:zoomto(510,170);
	--		self:diffuse(1.0,1.0,1.0,0.66);
			self:x(BASE_TOP_CENTER_X);
			self:y(BASE_TOP_CENTER_Y);
		end;
	};
--Jacket 
	Def.Banner{
		OnCommand=function(self)
			self:Load(drInfo["Jacket"]);
			self:scaletofit(-75,-75,75,75);
			self:x(DJACKET_CENTER_X);
			self:y(DJACKET_CENTER_Y);
		end;
	};
--Title 
	LoadFont("Common Normal")..{
		InitCommand=cmd(maxwidth,300;);
		OnCommand=function(self)
			self:diffuse(Str2Color(drInfo["Color"]));
			local c1=Str2Color(drInfo["Color"])[1];
			local c2=Str2Color(drInfo["Color"])[2];
			if tonumber(c2)<0.8 then
				self:strokecolor(Color("White"));
			else
				self:strokecolor(Color("Outline"));
			end;
			self:settext(drInfo["Title"]);
			self:x(DTITLE_CENTER_X);
			self:y(DTITLE_CENTER_Y-65);
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=cmd(maxwidth,300;);
		OnCommand=function(self)
			self:diffuse(Str2Color(lvInfo[""..sys_sellevel.."-Color"]));
			local c1=Str2Color(lvInfo[""..sys_sellevel.."-Color"])[1];
			local c2=Str2Color(lvInfo[""..sys_sellevel.."-Color"])[2];
			if tonumber(c2)<0.8 then
				self:strokecolor(Color("White"));
			else
				self:strokecolor(Color("Outline"));
			end;
			self:settext(lvInfo[""..sys_sellevel.."-Name"]);
			self:x(DTITLE_CENTER_X);
			self:y(DTITLE_CENTER_Y-30);
		end;
	};
	LoadActor(THEME:GetPathG("_Drills/drill","result"))..{
		InitCommand=function(self)
			self:x(DTITLE_CENTER_X);
			self:y(DTITLE_CENTER_Y+30);
			self:animate(false);
		end;
		OnCommand=function(self)
			if getenv("DrillFailed") then
				self:setstate(1);
				self:diffuseshift();
			else
				self:setstate(0);
				self:diffuseblink();
				self:effectcolor1(1,1,1,1);
				self:effectcolor2(1,1,1,0.66);
				self:effecttiming(0.1,0,0.1,0);
			end;
			self:diffusealpha(0);
			self:zoom(2);
			self:sleep(0.5);
			self:linear(0.5);
			self:zoom(1);
			self:diffusealpha(1);
		end;
	};

--Base(BOTTOM)
	--Def.Quad{
	LoadActor(THEME:GetPathG("_SelectMusic/white","banner"))..{
		OnCommand=function(self)
			self:zoomto(510,220);
	--		self:diffuse(1.0,1.0,1.0,0.66);
			self:x(BASE_BOTTOM_CENTER_X);
			self:y(BASE_BOTTOM_CENTER_Y);
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:maxwidth(150/0.75);
			self:x(BASE_BOTTOM_CENTER_X-250);
			self:y(BASE_BOTTOM_CENTER_Y-95);
			self:settext("Information");
		end;
	};
--Jacket
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Dark"));
			self:strokecolor(Color("White"));
			self:maxwidth(150/0.75);
			self:zoom(0.75);
			self:x(SJACKET_CENTER_X-75);
			self:y(SJACKET_CENTER_Y-90);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:settext("Main Results");
			else
				self:settext("Stage "..sys_selsong);
			end;
		end;
	};
	Def.Banner{
		SetCommand=function(self)
			if sys_selsong==0 then
				self:Load(lvInfo[""..sys_sellevel.."-Jacket"]);
			else
				if sg then
					self:Load(GetSongGPath(wheelmode,sg));
				else
					self:Load(THEME:GetPathG("Common fallback","jacket"));
				end;
			end;
			self:scaletofit(-75,-75,75,75);
			self:x(SJACKET_CENTER_X);
			self:y(SJACKET_CENTER_Y);
		end;
	};
--ClearBorder
	Def.Quad{
		OnCommand=function(self)
			self:zoomto(330,70);
			self:x(STITLE_CENTER_X);
			self:y(STITLE_CENTER_Y);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:diffuse(D3Color("Light"));
				self:diffusealpha(0.66);
				self:fadeleft(0.5);
			else
				self:diffuse(_DifficultyCOLOR2(difc,df));
				self:diffusealpha(0.66);
				self:fadeleft(0.5);
			end;
		end;
	};
	Def.Quad{
		InitCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Dark"));
			self:x(BORDER_CENTER_X-BORDER_W2-1);
			self:y(BORDER_CENTER_Y);
			self:zoomto(BORDER_W+2,10+2);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:visible(true);
			else
				self:visible(false);
			end;
		end;
	};
	Def.Quad{
		InitCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Text"));
			self:diffusetopedge(Color("White"));
			self:x(BORDER_CENTER_X-BORDER_W2);
			self:y(BORDER_CENTER_Y);
			self:zoomto(BORDER_W,10);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:visible(true);
			else
				self:visible(false);
			end;
		end;
	};
	Def.Quad{
		InitCommand=function(self)
			self:horizalign(right);
			self:diffuse(Color("Yellow"));
			self:diffusetopedge(Color("White"));
			self:x(BORDER_CENTER_X+BORDER_W2);
			self:y(BORDER_CENTER_Y);
			self:zoomto((100-tonumber(drInfo["Border"]))*BORDER_W100,10);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:visible(true);
			else
				self:visible(false);
			end;
		end;
	};
	Def.Quad{
		InitCommand=function(self)
			self:horizalign(left);
			if getenv("D3MIXMode") then
				self:diffuse(Color("Red"));
			else
				self:diffuse(Color("Blue"));
			end;
			self:diffusetopedge(Color("White"));
			self:diffusealpha(0.75);
			self:x(BORDER_CENTER_X-BORDER_W2);
			self:y(BORDER_CENTER_Y);
			self:zoomto(0,10);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:visible(true);
				self:linear(1.0);
				self:zoomto(DrillScore["Drill_DP"]*BORDER_W,10);
			else
				self:visible(false);
			end;
		end;
	};
	LoadActor(THEME:GetPathG("_Drills/drill","border"))..{
		InitCommand=function(self)
			self:horizalign(left);
			self:x(BORDER_CENTER_X-BORDER_W2-1+(tonumber(drInfo["Border"])*BORDER_W100));
			self:y(BORDER_CENTER_Y-20);
			self:animate(false);
			self:setstate(2);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:visible(true);
			else
				self:visible(false);
			end;
		end;
	};
	LoadActor(THEME:GetPathG("_Drills/drill","border"))..{
		InitCommand=function(self)
			self:horizalign(left);
			self:x(BORDER_CENTER_X-BORDER_W2-1);
			if getenv("DrillFailed") then
				self:setstate(0);
			else
				self:setstate(1);
			end;
			self:y(BORDER_CENTER_Y+20);
			self:animate(false);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:visible(true);
				self:linear(1.0);
				self:x(BORDER_CENTER_X-BORDER_W2-1+(DrillScore["Drill_DP"]*BORDER_W));
			else
				self:visible(false);
			end;
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(right);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:zoom(1.2);
			self:maxwidth(100/1.2);
			self:x(BORDER_CENTER_X+BORDER_W2+105);
			self:y(BORDER_CENTER_Y-2);
			self:settextf("%1.2f%%",DrillScore["Drill_DP"]*100);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:visible(true);
			else
				self:visible(false);
			end;
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(right);
			self:vertalign(bottom);
			self:strokecolor(Color("White"));
			self:zoom(0.75);
			self:maxwidth(280/0.75);
			self:x(STITLE_CENTER_X+120);
			self:y(STITLE_CENTER_Y+27);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:visible(false);
			else
				self:visible(true);
				self:diffuse(_DifficultyCOLOR2(difc,df));
				self:settext(_DifficultyNAME2(difn,df));
			end;
		end;
	};
--SongTitle & Meter 
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:vertalign(bottom);
			self:strokecolor(Color("White"));
			self:zoom(1.2);
			self:maxwidth(160/1.2);
			self:x(STITLE_CENTER_X+140);
			self:y(STITLE_CENTER_Y+25);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:visible(false);
			else
				self:visible(true);
				self:diffuse(_DifficultyCOLOR2(difc,df));
				if sg then
					local stt=GAMESTATE:GetCurrentStyle():GetStepsType();
					if stt then
						local st=sg:GetOneSteps(stt,df);
						self:settext(st:GetMeter());
					else
						self:settext("");
					end;
				else
					self:settext("");
				end;
			end;
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:maxwidth(320);
			self:x(STITLE_CENTER_X-160);
			self:y(STITLE_CENTER_Y-20);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:visible(false);
			else
				self:visible(true);
				self:settext(sg:GetDisplayFullTitle());
			end;
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:maxwidth(280/0.8);
			self:zoom(0.8);
			self:x(STITLE_CENTER_X-160);
			self:y(STITLE_CENTER_Y+3);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:visible(false);
			else
				self:visible(true);
				self:settext(sg:GetDisplayArtist());
			end;
		end;
	};
--Grade
	Def.Sprite{
		OnCommand=function(self)
			self:x(INFO_CENTER_X+100);
			self:y(INFO_CENTER_Y+62);
		end;
		SetCommand=function(self)
			local chk=(sys_selsong==0) and "-"..getenv("DrillMaxStage") or "-"..sys_selsong
			if getenv("DrillFailed") and DrillScore["Drill_LIFE"..chk]<=0 then
				self:Load(THEME:GetPathG("_GradeDisplay Normal/GradeDisplayEval","Failed"));
			elseif DrillScore["Drill_DP"..chk]>0 and DrillScore["Drill_W3"..chk]==0
				and DrillScore["Drill_W4"..chk]==0 and DrillScore["Drill_W5"..chk]==0
				and DrillScore["Drill_MS"..chk]==0 and DrillScore["Drill_NG"..chk]==0 then
				if DrillScore["Drill_W2"..chk]==0 then
					self:Load(THEME:GetPathG("_GradeDisplay Normal/GradeDisplayEval","Tier01"));
				else
					self:Load(THEME:GetPathG("_GradeDisplay Normal/GradeDisplayEval","Tier02"));
				end;
			elseif gradepoint>=tonumber(THEME:GetMetric("PlayerStageStats","GradePercentTier03")) then
				self:Load(THEME:GetPathG("_GradeDisplay Normal/GradeDisplayEval","Tier03"));
			elseif gradepoint>=tonumber(THEME:GetMetric("PlayerStageStats","GradePercentTier04")) then
				self:Load(THEME:GetPathG("_GradeDisplay Normal/GradeDisplayEval","Tier04"));
			elseif gradepoint>=tonumber(THEME:GetMetric("PlayerStageStats","GradePercentTier05")) then
				self:Load(THEME:GetPathG("_GradeDisplay Normal/GradeDisplayEval","Tier05"));
			elseif gradepoint>=tonumber(THEME:GetMetric("PlayerStageStats","GradePercentTier06")) then
				self:Load(THEME:GetPathG("_GradeDisplay Normal/GradeDisplayEval","Tier06"));
			else
				self:Load(THEME:GetPathG("_GradeDisplay Normal/GradeDisplayEval","Tier07"));
			end;
		end;
	};
--FullCombo 
	Def.Sprite{
		OnCommand=function(self)
			self:x(INFO_CENTER_X+140);
			self:y(INFO_CENTER_Y+32);
		end;
		SetCommand=function(self)
			local chk=(sys_selsong==0) and "" or "-"..sys_selsong;
			local fctype=nil;
			-- [ja] やべぇこれすっげーめんどい 
			-- [ja] Boo,Miss,NG,Hitの合計値が0、各ステージのコンボ数がTAPSの値より多ければとりあえずFC扱いで 
			if DrillScore["Drill_DP"..chk]>0 and DrillScore["Drill_W5"..chk]==0
					and DrillScore["Drill_MS"..chk]==0 and DrillScore["Drill_NG"..chk]==0
					and DrillScore["Drill_HIT"..chk]==0 and DrillScore["Drill_LIFE"..chk]>0 then
				local fcstage=true;
				if sys_selsong==0 then
					for stage=1,getenv("DrillMaxStage") do
						local _,_sg,_df=GetDrillSong(lvInfo[""..sys_sellevel.."-Song"][stage]);
						if _sg then
							local stt=GAMESTATE:GetCurrentStyle():GetStepsType();
							if stt then
								local st=_sg:GetOneSteps(stt,_df);
								if DrillScore["Drill_COMBO-"..stage]<st:GetRadarValues(GAMESTATE:GetMasterPlayerNumber()):GetValue('RadarCategory_TapsAndHolds') then
									fcstage=false;
									break;
								end;
							else
								fcstage=false;
							end;
						else
							fcstage=false;
						end;
					end;
				else
					if sg then
						local stt=GAMESTATE:GetCurrentStyle():GetStepsType();
						if stt then
							local st=sg:GetOneSteps(stt,df);
							if DrillScore["Drill_COMBO-"..sys_selsong]<st:GetRadarValues(GAMESTATE:GetMasterPlayerNumber()):GetValue('RadarCategory_TapsAndHolds') then
								fcstage=false;
							end;
						else
							fcstage=false;
						end;
					else
						fcstage=false;
					end;
				end;
				if fcstage then
					if DrillScore["Drill_W4"..chk]==0 then
						if DrillScore["Drill_W3"..chk]==0 then
							if DrillScore["Drill_W2"..chk]==0 then
								fctype="JudgmentLine_W1";
							else
								fctype="JudgmentLine_W2";
							end;				
						else
							fctype="JudgmentLine_W3";
						end;			
					else
						fctype="JudgmentLine_W4";
					end;
				else
					fctype=nil;
				end;
			else
				fctype=nil;
			end;
			if fctype then
				if fctype=="JudgmentLine_W1" then
					self:Load(THEME:GetPathG("_GradeDisplay Small/_ScreenSelectMusic","2x FullCombo"));
					self:diffuse(GameColor.Judgment["JudgmentLine_W1"]);
					self:zoom(2.5/2);
				elseif fctype=="JudgmentLine_W2" then
					self:Load(THEME:GetPathG("_GradeDisplay Small/_ScreenSelectMusic","2x FullCombo"));
					self:diffuse(GameColor.Judgment["JudgmentLine_W2"]);
					self:zoom(2.2/2);
				elseif fctype=="JudgmentLine_W3" then
					self:Load(THEME:GetPathG("_GradeDisplay Small/_ScreenSelectMusic","2x FullCombo"));
					self:diffuse(GameColor.Judgment["JudgmentLine_W3"]);
					self:zoom(2.0/2);
				elseif fctype=="JudgmentLine_W4" then
					self:Load(THEME:GetPathG("_GradeDisplay Small/_ScreenSelectMusic","2x GoodFullCombo"));
					self:diffuse(GameColor.Judgment["JudgmentLine_W4"]);
					self:zoom(2.5/2);
				else
					self:Load(THEME:GetPathG("","_blank"));
					self:zoom(0);
					self:diffuse(1.0,1.0,1.0,0);
				end;
			else
				self:Load(THEME:GetPathG("","_blank"));
				self:zoom(0);
				self:diffuse(1.0,1.0,1.0,0);
			end;
		end;
	};
-- Life
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Text"));
			self:skewx(-0.1);
			self:shadowlength(1);
			self:shadowcolor(Color("White"));
			self:maxwidth(80/0.66);
			self:zoom(0.66);
			self:x(INFO_CENTER_X-10);
			self:y(INFO_CENTER_Y-14);
		end;
		SetCommand=function(self)
			self:settext((sys_selsong==0) and "LIFE (Avg)" or "LIFE");
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(right);
			self:diffuse(D3Color("Text"));
			self:skewx(-0.1);
			self:shadowlength(1);
			self:shadowcolor(Color("White"));
			self:maxwidth(90/0.66);
			self:zoom(0.66);
			self:x(INFO_CENTER_X+130);
			self:y(INFO_CENTER_Y-14);
		end;
		SetCommand=function(self)
			local chk=(sys_selsong==0) and "" or "-"..sys_selsong;
			self:settextf("%3.1f%%",DrillScore["Drill_LIFE"..chk]*100);
		end;
	};
-- DancePoints
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Text"));
			self:skewx(-0.1);
			self:shadowlength(1);
			self:shadowcolor(Color("White"));
			self:maxwidth(80/0.66);
			self:zoom(0.66);
			self:x(INFO_CENTER_X-10);
			self:y(INFO_CENTER_Y+2);
			self:settext("DANCEPOINTS");
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(right);
			self:diffuse(D3Color("Text"));
			self:skewx(-0.1);
			self:shadowlength(1);
			self:shadowcolor(Color("White"));
			self:maxwidth(90/0.66);
			self:zoom(0.66);
			self:x(INFO_CENTER_X+130);
			self:y(INFO_CENTER_Y+2);
		end;
		SetCommand=function(self)
			local chk=(sys_selsong==0) and "" or "-"..sys_selsong;
			self:settextf("%3.1f%%",DrillScore["Drill_DP"..chk]*100);
		end;
	};
-- MaxCombo
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Text"));
			self:skewx(-0.1);
			self:shadowlength(1);
			self:shadowcolor(Color("White"));
			self:maxwidth(80/0.66);
			self:zoom(0.66);
			self:x(INFO_CENTER_X-10);
			self:y(INFO_CENTER_Y+18);
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:settext("");
			else
				self:settext("MAXCOMBO");
			end;
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(right);
			self:diffuse(D3Color("Text"));
			self:skewx(-0.1);
			self:shadowlength(1);
			self:shadowcolor(Color("White"));
			self:maxwidth(90/0.66);
			self:zoom(0.66);
			self:x(INFO_CENTER_X+118);
			self:y(INFO_CENTER_Y+18);
		end;
		SetCommand=function(self)
			local chk=(sys_selsong==0) and "" or "-"..sys_selsong;
			if sys_selsong==0 then
				self:settext("");
			else
				self:settextf("%3d",DrillScore["Drill_COMBO-"..sys_selsong]);
			end;
		end;
	};
-- カロリー 
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:player(PLAYER_1);
			--self:diffuse(PlayerColor(PLAYER_1));
			self:diffuse(Color("White"));
			self:strokecolor(PlayerColor(getenv("DrillPlayer")));
			self:zoom(0.8)
			self:x((getenv("DrillPlayer")==PLAYER_1) and 80+_HS or SCREEN_RIGHT-80);
			self:y(SCREEN_BOTTOM-60);
		end;
		SetCommand=function(self)
			local chk=(sys_selsong==0) and "" or "-"..sys_selsong;
			self:settextf("%.2f kcal\n%.2f kcal", DrillScore["Drill_CAL"..chk], cal_total);
		end;
	};
-- Options
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:player(PLAYER_1);
			--self:diffuse(PlayerColor(PLAYER_1));
			self:diffuse(PlayerColor(getenv("DrillPlayer")));
			self:zoom(0.5);
			self:maxwidth(320/0.5);
			self:horizalign(right);
			self:x(INFO_CENTER_X+170);
			self:y(INFO_CENTER_Y+100);
			local ps = GAMESTATE:GetPlayerState(getenv("DrillPlayer"));
			local po = ps:GetPlayerOptions("ModsLevel_Preferred");
			local modstr = ps:GetPlayerOptionsString("ModsLevel_Preferred")
			self:settext(modstr);
		end;
	};

	LoadActor(THEME:GetPathG("EditMenu","Left"))..{
		InitCommand=function(self)
			self:x(BASE_BOTTOM_CENTER_X-270);
			self:y(BASE_BOTTOM_CENTER_Y);
		end;
	};
	LoadActor(THEME:GetPathG("EditMenu","Right"))..{
		InitCommand=function(self)
			self:x(BASE_BOTTOM_CENTER_X+270);
			self:y(BASE_BOTTOM_CENTER_Y);
		end;
	};
};
--[ja] Judgmentですの 
juds={"JudgmentLine_W1","JudgmentLine_W2","JudgmentLine_W3",
	"JudgmentLine_W4","JudgmentLine_W5","JudgmentLine_Miss","JudgmentLine_Held"};
judi={"W1","W2","W3","W4","W5","MS","OK"};
for i=1,7 do
t2[#t2+1]=Def.ActorFrame{
	OnCommand=function(self)
		self:queuecommand("Set");
		self:addy(-SCREEN_HEIGHT);
		self:decelerate(_TT.S_IN);
		self:addy(SCREEN_HEIGHT);
	end;
	OffCommand=function(self)
		self:accelerate(_TT.S_OUT);
		self:addy(SCREEN_HEIGHT);
	end;
	SetRCommand=function(self)
		self:finishtweening();
		self:queuecommand("Set");
	end;
	SetCommand=function(self)
		self:x(INFO_CENTER_X);
		self:y(INFO_CENTER_Y-30);
	end;
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(left);
			self:diffuse(GameColor.Judgment[juds[i]]);
			self:skewx(-0.1);
			self:shadowlength(1);
			self:shadowcolor(Color("Outline"));
			self:maxwidth(75/0.66);
			self:zoom(0.66);
			self:x(-150);
			self:y(i*16)
		end;
		SetCommand=function(self)
			self:settext(_JudgementLabel2(jud,juds[i]));
			if i==10 then
				if sys_selsong==0 then
					self:visible(false);
				else
					self:visible(true);
				end;
			else
				self:visible(true);
			end;
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(right);
			self:diffuse(GameColor.Judgment[juds[i]]);
			self:skewx(-0.1);
			self:shadowlength(1);
			self:shadowcolor(Color("Outline"));
			self:maxwidth(40/0.66);
			self:zoom(0.66);
			self:x(-30);
			self:y(i*16)
		end;
		SetCommand=function(self)
			if sys_selsong==0 then
				self:settext(DrillScore["Drill_"..judi[i]]);
			else
				self:settext(DrillScore["Drill_"..judi[i].."-"..sys_selsong]);
			end;
			if i==8 then
				if sys_selsong==0 then
					self:visible(false);
				else
					self:visible(true);
				end;
			else
				self:visible(true);
			end;
		end;
	};
};
end;
t2[#t2+1]=Def.ActorFrame{
	LoadActor(THEME:GetPathG("ScreenWithMenuElements","header"))..{
		InitCommand=function(self)
			self:x(SCREEN_LEFT);
			self:y(SCREEN_CENTER_Y-15);
		end;
	};
};
t2[#t2+1]=Def.ActorFrame{
	OnCommand=function(self)
		self:addy(-SCREEN_HEIGHT);
		self:decelerate(_TT.S_IN);
		self:addy(SCREEN_HEIGHT);
	end;
	OffCommand=function(self)
		self:accelerate(_TT.S_OUT);
		self:addy(SCREEN_HEIGHT);
	end;
	LoadActor(THEME:GetPathG("ScreenWithMenuElements","footer"))..{
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X);
			self:y(SCREEN_BOTTOM);
		end;
	};
	LoadActor(THEME:GetPathG("ScreenWithMenuElements","help"))..{
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X);
			self:y(SCREEN_BOTTOM-16);
			(cmd(SetSecsBetweenSwitches,4;zoom,0.675;maxwidth,(SCREEN_WIDTH-300)/0.675;shadowlength,1;strokecolor,Color("Black");draworder,105;zoomy,0;zoom,1*0.675;linear,0.175))(self);
		end;
	};
};

local oTime=0;
local nTime=0;
local wait=1.0/60;
local sys_offcommand=false;
local function update(self,dt)
	nTime=nTime+dt;
	-- [ja] 1回分の処理 
	if nTime-oTime>wait then
		if getenv("sys_selected") and not sys_offcommand then
			sys_offcommand=true;
			self:queuecommand("Off");
		end;
		if getenv("sys_move") then
			self:queuecommand("SetR");
		end;
		oTime=oTime+wait;
	end;
end;
t2.InitCommand=cmd(SetUpdateFunction,update);
t[#t+1]=t2;
return t;